# SimpUI

**SimpUI** is a lightweight, pure CSS and JavaScript UI component library designed to help you build beautiful, interactive interfaces — fast and without dependencies.

Just include the SimpUI CSS and JS files in your project, and you’re ready to go.  
No build steps, no frameworks, no headaches.

---

## 🌐 Demo
Check out the live demo of SimpUI here:
https://simpui.reasadazim.com/

---

## ✨ Features

- **Modern, responsive components** that work on any device  
- **Zero dependencies** — just plain CSS & JS  
- **Easy customization** to match your brand style  
- **Quick setup** — start building in seconds  

SimpUI is perfect for developers who want **simplicity**, **speed**, and **flexibility** in their projects.

---

## 📦 Installation

Getting started with SimpUI is quick and easy:

### 1️⃣ Download the Bundle
Clone this repository or [download the latest release](https://github.com/reasadazim/simpui/archive/refs/heads/main.zip) to get started.

```bash
git clone https://github.com/reasadazim/simpui.git
```

---

### 2️⃣ Include Styles in `<head>`

Add these lines before your closing `</head>` tag:

```html
<link rel="stylesheet" href="simpui.css">
<link rel="stylesheet" href="simpicker.css">
<script src="simpicker.js"></script>
```

---

### 3️⃣ Include JavaScript before `</body>`

```html
<script src="simpui.js"></script>
```

---

### 4️⃣ You’re Done! 🎉

Start using SimpUI components in your HTML — no build process, no dependencies.

---

## 🚀 Example Usage

```html
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>SimpUI Example</title>
  <link rel="stylesheet" href="simpui.css">
  <link rel="stylesheet" href="simpicker.css">
  <script src="simpicker.js"></script>
</head>
<body>

  <button class="simpui-btn">Click Me</button>

  <script src="simpui.js"></script>
</body>
</html>
```

---

## 🛠 Customization

You can easily override SimpUI's default styles by adding your own CSS rules **after** including `simpui.css`.

Example:

```css
.simpui-btn {
  background-color: #4cafef;
  border-radius: 8px;
}
```

---

## 📄 License

SimpUI is released under the [GPL-3.0](LICENSE).

---

## 🤝 Contributing

Pull requests are welcome!  
If you find a bug or have an idea for a new component, feel free to [open an issue](https://github.com/reasadazim/simpui/issues).

---

**Made with ❤️ for simplicity.**
